/*
 * Decompiled with CFR 0.152.
 */
package com.github.olga_yakovleva.rhvoice;

import com.github.olga_yakovleva.rhvoice.Logger;
import com.github.olga_yakovleva.rhvoice.RHVoiceException;
import com.github.olga_yakovleva.rhvoice.SynthesisParameters;
import com.github.olga_yakovleva.rhvoice.TTSClient;
import com.github.olga_yakovleva.rhvoice.TextUtils;
import com.github.olga_yakovleva.rhvoice.VoiceInfo;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;

public final class TTSEngine {
    private long data;
    private static boolean jniLoaded = false;

    private static native void onClassInit();

    private native void onInit(String var1, String var2, String[] var3, Logger var4) throws RHVoiceException;

    private native void onShutdown();

    private native VoiceInfo[] doGetVoices();

    private native void doSpeak(String var1, SynthesisParameters var2, TTSClient var3) throws RHVoiceException;

    private native boolean doConfigure(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadJniLib(ClassLoader classLoader, String string) {
        String string2 = System.getProperty("sun.arch.data.model");
        String string3 = System.getProperty("os.name");
        try {
            String string4 = "com/github/olga_yakovleva/rhvoice/jni/" + string3 + "/" + string2 + "/" + string;
            URL uRL = classLoader.getResource(string4);
            if (uRL == null) {
                throw new RuntimeException("No resource " + string4);
            }
            File file = File.createTempFile(".rhvoice.jni.", "." + string + ".tmp");
            try (InputStream inputStream = uRL.openStream();){
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            System.load(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load " + string, throwable);
        }
    }

    static void loadJni(ClassLoader classLoader) {
        if (jniLoaded) {
            return;
        }
        TTSEngine.loadJniLib(classLoader, "libRHVoice_core.so");
        TTSEngine.loadJniLib(classLoader, "libRHVoice_jni.so");
        TTSEngine.loadJniLib(classLoader, "libRHVoice.so");
        TTSEngine.onClassInit();
        jniLoaded = true;
    }

    public TTSEngine(String string, String string2, String[] stringArray, Logger logger) throws RHVoiceException {
        if (logger == null) {
            throw new NullPointerException("logger can't be null");
        }
        TTSEngine.loadJni(this.getClass().getClassLoader());
        this.onInit(string, string2, stringArray, logger);
    }

    public TTSEngine(String string, String string2, List<String> list, Logger logger) throws RHVoiceException {
        this(string, string2, list.toArray(new String[list.size()]), logger);
    }

    public TTSEngine() throws RHVoiceException {
        this("", "", new String[0], null);
    }

    public void shutdown() {
        this.onShutdown();
    }

    public List<VoiceInfo> getVoices() {
        return Arrays.asList(this.doGetVoices());
    }

    public void speak(String string, SynthesisParameters synthesisParameters, TTSClient tTSClient) throws RHVoiceException {
        if (synthesisParameters.getVoiceProfile() == null) {
            throw new RHVoiceException("Voice not set");
        }
        this.doSpeak(string, synthesisParameters, tTSClient);
    }

    public boolean configure(String string, String string2) {
        if (TextUtils.isEmpty(string)) {
            return false;
        }
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        return this.doConfigure(string, string2);
    }
}

