/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.mssapi;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.luwrain.base.ExtensionObject;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.extensions.EmptyExtension;
import org.luwrain.extensions.mssapi.SapiChannel;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Engine;

public final class Extension
extends EmptyExtension {
    static final String LOG_COMPONENT = "mssapi";

    public ExtensionObject[] getExtObjects(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        return new ExtensionObject[]{new Engine(){

            public String getExtObjName() {
                return Extension.LOG_COMPONENT;
            }

            public Set<Engine.Features> getFeatures() {
                return EnumSet.of(Engine.Features.CAN_SYNTH_TO_STREAM, Engine.Features.CAN_SYNTH_TO_SPEAKERS);
            }

            public Channel newChannel(Map<String, String> params) {
                NullCheck.notNull(params, (String)"params");
                try {
                    return new SapiChannel(params);
                }
                catch (Exception e) {
                    Log.error((String)Extension.LOG_COMPONENT, (String)("unable to create a SAPI channel:" + e.getClass().getName() + ":" + e.getMessage()));
                    return null;
                }
            }
        }};
    }
}

