/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.mssapi;

import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.extensions.mssapi.SAPIImpl;
import org.luwrain.extensions.mssapi.SAPIVoice;
import org.luwrain.extensions.mssapi.SSML;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Voice;

final class SapiChannel
implements Channel {
    private static final String LOG_COMPONENT = "mssapi";
    private static final int UPPER_CASE_PITCH_MODIFIER = 30;
    private static final int COPY_WAV_BUF_SIZE = 1024;
    private final SAPIImpl impl = new SAPIImpl();
    private int curPitch = 100;
    private int curRate = 60;
    private final File tempFile;

    SapiChannel(Map<String, String> params) throws Exception {
        NullCheck.notNull(params, (String)"params");
        int count = this.impl.searchVoiceByAttributes(params.containsKey("cond") ? params.get("cond") : null);
        if (count == -1) {
            throw new Exception("unable to find a suitable voice due to unexpected error");
        }
        String voiceId = this.impl.getNextVoiceIdFromList();
        int res = this.impl.selectCurrentVoice();
        if (res != 0) {
            throw new Exception("unable to select the voice which was found");
        }
        this.tempFile = File.createTempFile("sapi", ".tmp.wav");
    }

    public long speak(String text, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        NullCheck.notNull((Object)text, (String)"text");
        this.impl.pitch(10);
        this.impl.rate(10);
        new Thread(() -> {
            this.impl.speak(text, 18);
            listener.onFinished(-1L);
        }).start();
        if (relPitch != 0) {
            this.impl.pitch(this.curPitch);
        }
        if (relRate != 0) {
            this.impl.rate(this.convRate(this.curRate));
        }
        return -1L;
    }

    public long speakLetter(char letter, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        NullCheck.notNull((Object)Character.valueOf(letter), (String)"letter");
        if (relPitch != 0) {
            this.impl.pitch(this.limit100(this.curPitch + relPitch));
        }
        if (relRate != 0) {
            this.impl.rate(this.convRate(this.limit100(this.curRate + relRate)));
        }
        this.impl.speak(SSML.upperCasePitchControl("" + letter, 30), 9 | (cancelPrevious ? 2 : 0));
        if (relPitch != 0) {
            this.impl.pitch(this.curPitch);
        }
        if (relRate != 0) {
            this.impl.rate(this.convRate(this.curRate));
        }
        return -1L;
    }

    public void silence() {
        this.impl.speak("", 2);
    }

    public AudioFormat[] getSynthSupportedFormats() {
        return null;
    }

    public Voice[] getVoices() {
        String id;
        this.impl.searchVoiceByAttributes(null);
        LinkedList<SAPIVoice> voices = new LinkedList<SAPIVoice>();
        while ((id = this.impl.getNextVoiceIdFromList()) != null) {
            voices.add(new SAPIVoice(id, this.impl.getLastVoiceDescription(), false));
        }
        return voices.toArray(new Voice[voices.size()]);
    }

    public String getChannelName() {
        return "Microsoft Speech API";
    }

    public Channel.Result synth(String text, OutputStream stream, AudioFormat format, Channel.SyncParams params, Set<Channel.Flags> flags) {
        return new Channel.Result(Channel.Result.Type.NOT_IMPLEMENTED);
    }

    public void setVoice(String name) {
    }

    public String getVoiceName() {
        return "default";
    }

    public void close() {
    }

    private int limit100(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        return value;
    }

    private int chooseSAPIAudioFormatFlag(AudioFormat format) {
        int sapiaudio = -1;
        if (format.getChannels() == 1) {
            if (format.getSampleSizeInBits() == 8) {
                if (format.getFrameRate() <= 8000000.0f) {
                    sapiaudio = 4;
                } else if (format.getFrameRate() <= 1.1E7f) {
                    sapiaudio = 8;
                } else if (format.getFrameRate() <= 1.2E7f) {
                    sapiaudio = 12;
                } else if (format.getFrameRate() <= 1.6E7f) {
                    sapiaudio = 16;
                } else if (format.getFrameRate() <= 2.2E7f) {
                    sapiaudio = 20;
                } else if (format.getFrameRate() <= 2.4E7f) {
                    sapiaudio = 24;
                } else if (format.getFrameRate() <= 3.2E7f) {
                    sapiaudio = 28;
                } else if (format.getFrameRate() <= 4.4E7f) {
                    sapiaudio = 32;
                } else if (format.getFrameRate() <= 4.8E7f) {
                    sapiaudio = 36;
                } else {
                    Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample frame too big " + format.getFrameRate()));
                }
            } else if (format.getSampleSizeInBits() == 16) {
                if (format.getFrameRate() <= 8000000.0f) {
                    sapiaudio = 6;
                } else if (format.getFrameRate() <= 1.1E7f) {
                    sapiaudio = 10;
                } else if (format.getFrameRate() <= 1.2E7f) {
                    sapiaudio = 14;
                } else if (format.getFrameRate() <= 1.6E7f) {
                    sapiaudio = 18;
                } else if (format.getFrameRate() <= 2.2E7f) {
                    sapiaudio = 22;
                } else if (format.getFrameRate() <= 2.4E7f) {
                    sapiaudio = 26;
                } else if (format.getFrameRate() <= 3.2E7f) {
                    sapiaudio = 30;
                } else if (format.getFrameRate() <= 4.4E7f) {
                    sapiaudio = 34;
                } else if (format.getFrameRate() <= 4.8E7f) {
                    sapiaudio = 38;
                } else {
                    Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample frame too big " + format.getFrameRate()));
                }
            } else {
                Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample size can be 8 or 16 bit, but specified " + format.getSampleSizeInBits()));
            }
        } else if (format.getSampleSizeInBits() == 8) {
            if (format.getFrameRate() <= 8000000.0f) {
                sapiaudio = 5;
            } else if (format.getFrameRate() <= 1.1E7f) {
                sapiaudio = 9;
            } else if (format.getFrameRate() <= 1.2E7f) {
                sapiaudio = 13;
            } else if (format.getFrameRate() <= 1.6E7f) {
                sapiaudio = 17;
            } else if (format.getFrameRate() <= 2.2E7f) {
                sapiaudio = 21;
            } else if (format.getFrameRate() <= 2.4E7f) {
                sapiaudio = 25;
            } else if (format.getFrameRate() <= 3.2E7f) {
                sapiaudio = 29;
            } else if (format.getFrameRate() <= 4.4E7f) {
                sapiaudio = 33;
            } else if (format.getFrameRate() <= 4.8E7f) {
                sapiaudio = 37;
            } else {
                Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample frame too big " + format.getFrameRate()));
            }
        } else if (format.getSampleSizeInBits() == 16) {
            if (format.getFrameRate() <= 8000000.0f) {
                sapiaudio = 7;
            } else if (format.getFrameRate() <= 1.1E7f) {
                sapiaudio = 11;
            } else if (format.getFrameRate() <= 1.2E7f) {
                sapiaudio = 15;
            } else if (format.getFrameRate() <= 1.6E7f) {
                sapiaudio = 19;
            } else if (format.getFrameRate() <= 2.2E7f) {
                sapiaudio = 23;
            } else if (format.getFrameRate() <= 2.4E7f) {
                sapiaudio = 27;
            } else if (format.getFrameRate() <= 3.2E7f) {
                sapiaudio = 31;
            } else if (format.getFrameRate() <= 4.4E7f) {
                sapiaudio = 35;
            } else if (format.getFrameRate() <= 4.8E7f) {
                sapiaudio = 39;
            } else {
                Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample frame too big " + format.getFrameRate()));
            }
        } else {
            Log.warning((String)LOG_COMPONENT, (String)("Audioformat sample size can be 8 or 16 bit, but specified " + format.getSampleSizeInBits()));
        }
        return sapiaudio;
    }

    private int convRate(int rate100) {
        return Math.round(10 - rate100 / 5);
    }
}

