/*
 * Decompiled with CFR 0.152.
 */
package shapes;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Shapes {
    static final File IMAGES_DIR = new File("images");
    static final File TODO_DIR = new File("\u041d\u0435\u0440\u0430\u0437\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u0435");
    static final File READY_DIR = new File("\u0420\u0430\u0437\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u0435");
    final File[] images;
    int currentImage = 0;
    final File[] todoFiles;
    int current = 0;
    final List<Point> points = new LinkedList<Point>();
    ImagePanel panel = null;

    Shapes() {
        this.images = IMAGES_DIR.listFiles();
        this.todoFiles = TODO_DIR.listFiles();
    }

    public static void main(String[] args) throws Exception {
        new Shapes().go();
    }

    void go() throws Exception {
        JFrame frame = new JFrame();
        this.panel = new ImagePanel();
        frame.getContentPane().add(this.panel);
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.pack();
        frame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 34) {
                    if (Shapes.this.currentImage + 1 >= Shapes.this.images.length) {
                        return;
                    }
                    ++Shapes.this.currentImage;
                    try {
                        Shapes.this.panel.image = ImageIO.read(Shapes.this.images[Shapes.this.currentImage]);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage());
                        return;
                    }
                    Shapes.this.panel.revalidate();
                    Shapes.this.panel.repaint();
                    return;
                }
                if (e.getKeyCode() == 33) {
                    if (Shapes.this.currentImage == 0) {
                        return;
                    }
                    --Shapes.this.currentImage;
                    try {
                        Shapes.this.panel.image = ImageIO.read(Shapes.this.images[Shapes.this.currentImage]);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage());
                        return;
                    }
                    Shapes.this.panel.revalidate();
                    Shapes.this.panel.repaint();
                    return;
                }
                if (e.getKeyChar() == '\n') {
                    Shapes.this.savePoints(Shapes.this.points, new File(READY_DIR, Shapes.this.todoFiles[Shapes.this.current].getName()));
                    Shapes.this.points.clear();
                    Shapes.this.todoFiles[Shapes.this.current].delete();
                    ++Shapes.this.current;
                    if (Shapes.this.current == Shapes.this.todoFiles.length) {
                        JOptionPane.showMessageDialog(null, "\u0411\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u0442\u0443, \u0437\u0430\u043a\u0440\u043e\u0439 \u043c\u0435\u043d\u044f!");
                    }
                    Shapes.this.panel.revalidate();
                    Shapes.this.panel.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void savePoints(List<Point> points, File fileTo) {
        try {
            FileOutputStream s = new FileOutputStream(fileTo);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(s));
            try {
                for (Point p : points) {
                    w.write(String.valueOf(p.getX()) + ":" + String.valueOf(p.getY()));
                    w.newLine();
                }
            }
            finally {
                w.flush();
                s.flush();
                w.close();
                ((OutputStream)s).close();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getClass().getName() + ":" + e.getMessage());
        }
    }

    class ImagePanel
    extends JPanel {
        BufferedImage image = null;

        ImagePanel() throws Exception {
            this.setPreferredSize(new Dimension(500, 500));
            this.image = ImageIO.read(Shapes.this.images[Shapes.this.currentImage]);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Shapes.this.points.add(e.getPoint());
                    ImagePanel.this.revalidate();
                    ImagePanel.this.repaint();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (Shapes.this.current == Shapes.this.todoFiles.length) {
                return;
            }
            g.drawImage(this.image, 0, 0, this);
            g.drawString(Shapes.this.todoFiles[Shapes.this.current].getName(), 20, 20);
            if (Shapes.this.points.size() > 1) {
                for (int i = 0; i < Shapes.this.points.size() - 1; ++i) {
                    g.drawLine((int)Shapes.this.points.get(i).getX(), (int)Shapes.this.points.get(i).getY(), (int)Shapes.this.points.get(i + 1).getX(), (int)Shapes.this.points.get(i + 1).getY());
                }
            }
        }
    }
}

